################################################################################
##### FUNCTIONS ################################################################
################################################################################










##### Gibbs and Gibbs-like update functions ####################################
################################################################################
##### Non-linear trend proposal function #######################################
u.prop.function <- function(i, tPtsPer, V1Inv.diag, Vinv.M, theta.star, theta.old, u.old) {
    ############################################################################
    ### This function is used to propose new values for the non-linear change  #
    ### over time component of the model. It is based on "Gaussian Markov      #
    ### Random Fields: Theory and Applications, Rue H, Held L, Chapman and     #
    ### Hall 2005". A full description of the application to metabolic risks   #
    ### data is provided in Finucane et al and the appendix of Danaei et al.   #
    ### There are three possible scenarios: no data observed in a country, one #
    ### year of data observed, or two or more years observed                   #
    ############################################################################
    val.sw <- paste("val",tPtsPer[i],sep='')                                            # Produces a character string containing the number of time points for a country
    switch(val.sw,                                                                      # Calls appropriate section of function depending on number of time points for a country
        val0 = {                                                                        # No data for that country
            uStar                           <- eigenNoData$vec %*% (1/ sqrt(exp(theta.star)*eigenNoData$val) * rnorm(T))
            uStar.old                       <- eigenNoData$vec %*% (1/ sqrt(exp(theta.old)* eigenNoData$val) * rnorm(T))
            dens                            <- 1/2 * (T-2)*theta.star - 1/2 * t(uStar) %*% (exp(theta.star) * SigmaGenInvNoTheta %*% uStar)
            dens.old                        <- 1/2 * (T-2)*theta.old  - 1/2 * t(u.old[((i-1)*T+1):(i*T)]) %*% (exp(theta.old) * SigmaGenInvNoTheta %*% u.old[((i-1)*T+1):(i*T)])
            return(list(u.star=uStar, dens.star=dens, u.star.old=uStar.old, dens.old=dens.old))
            },
        val1 = {                                                                        # One datapoint for that country
            Q                               <- exp(theta.star) * P
            diag(Q)                         <- diag(Q) + V1Inv.diag[((i-1)*T+1):(i*T)]
            Q.eigen                         <- eigen(Q)
            Q.eigen$values[T]               <- Inf
            Qinv                            <- Q.eigen$vectors %*% (1/Q.eigen$values * t(Q.eigen$vectors))
            correct.factor                  <- Qinv %*% matrix(1, T, T) / sum(Qinv)
            mu                              <- Qinv %*% Vinv.M[((i-1)*T+1):(i*T)]
            muStar                          <- mu - correct.factor %*% mu
            SigmaStar                       <- Qinv - correct.factor %*% Qinv
            SigmaStar.eigen                 <- eigen(SigmaStar)
            SigmaStar.eigen$val[(T-1):T]    <- 0
            EigenValGenInv                  <- 1/SigmaStar.eigen$val
            EigenValGenInv[(T-1):T]         <- 0
            SigmaGenInv                     <- SigmaStar.eigen$vec %*% (EigenValGenInv * t(SigmaStar.eigen$vec))
            uStar                           <- muStar + SigmaStar.eigen$vec %*% (sqrt(SigmaStar.eigen$val) * rnorm(T))
            dens                            <- -1/2 * sum(log(SigmaStar.eigen$val[1:(T-2)])) -1/2 * t(uStar - muStar) %*% (SigmaGenInv %*% (uStar - muStar))
            Q                               <- exp(theta.old) * P
            diag(Q)                         <- diag(Q) + V1Inv.diag[((i-1)*T+1):(i*T)]
            Q.eigen                         <- eigen(Q)
            Q.eigen$values[T]               <- Inf
            Qinv                            <- Q.eigen$vectors %*% (1/Q.eigen$values * t(Q.eigen$vectors))
            correct.factor                  <- Qinv %*% matrix(1, T, T) / sum(Qinv)
            mu                              <- Qinv %*% Vinv.M[((i-1)*T+1):(i*T)]
            muStar                          <- mu - correct.factor %*% mu
            SigmaStar                       <- Qinv - correct.factor %*% Qinv
            SigmaStar.eigen                 <- eigen(SigmaStar)
            SigmaStar.eigen$val[(T-1):T]    <- 0
            EigenValGenInv                  <- 1/SigmaStar.eigen$val
            EigenValGenInv[(T-1):T]         <- 0
            SigmaGenInv                     <- SigmaStar.eigen$vec %*% (EigenValGenInv * t(SigmaStar.eigen$vec))
            uStar.old                       <- muStar + SigmaStar.eigen$vec %*% (sqrt(SigmaStar.eigen$val) * rnorm(T))
            dens.old                        <- -1/2*sum(log(SigmaStar.eigen$val[1:(T-2)])) - 1/2*t(u.old[((i-1)*T+1):(i*T)] - muStar) %*% (SigmaGenInv %*% (u.old[((i-1)*T+1):(i*T)] - 
                                                muStar))
            return(list(u.star=uStar, dens.star=dens, u.star.old=uStar.old, dens.old=dens.old))
            },
            {                                                                           # Two or more datapoints for that country
            Q                               <- exp(theta.star) * P
            diag(Q)                         <- diag(Q) + V1Inv.diag[((i-1)*T+1):(i*T)]
            Qinv                            <- solve(Q)
            correct.factor                  <- Qinv %*% t(A) %*% solve(A %*% Qinv %*% t(A)) %*% A
            mu                              <- Qinv %*% Vinv.M[((i-1)*T+1):(i*T)]
            muStar                          <- mu - correct.factor %*% mu
            SigmaStar                       <- Qinv - correct.factor %*% Qinv
            SigmaStar.eigen                 <- eigen(SigmaStar)
            SigmaStar.eigen$val[(T-1):T]    <- 0
            EigenValGenInv                  <- 1/SigmaStar.eigen$val
            EigenValGenInv[(T-1):T]         <- 0
            SigmaGenInv                     <- SigmaStar.eigen$vec %*% (EigenValGenInv * t(SigmaStar.eigen$vec))
            uStar                           <- muStar + SigmaStar.eigen$vec %*% (sqrt(SigmaStar.eigen$val) * rnorm(T))
            dens                            <- -1/2 * sum(log(SigmaStar.eigen$val[1:(T-2)])) -1/2 * t(uStar - muStar) %*% (SigmaGenInv %*%  (uStar - muStar))
            Q                               <- exp(theta.old) * P
            diag(Q)                         <- diag(Q) + V1Inv.diag[((i-1)*T+1):(i*T)]
            Qinv                            <- solve(Q)
            correct.factor                  <- Qinv %*% t(A) %*% solve(A %*% Qinv %*% t(A)) %*% A
            mu                              <- Qinv %*% Vinv.M[((i-1)*T+1):(i*T)]
            muStar                          <- mu - correct.factor %*% mu
            SigmaStar                       <- Qinv - correct.factor %*% Qinv
            SigmaStar.eigen                 <- eigen(SigmaStar)
            SigmaStar.eigen$val[(T-1):T]    <- 0
            EigenValGenInv                  <- 1/SigmaStar.eigen$val
            EigenValGenInv[(T-1):T]         <- 0
            SigmaGenInv                     <- SigmaStar.eigen$vec %*% (EigenValGenInv * t(SigmaStar.eigen$vec))
            uStar.old                       <- muStar + SigmaStar.eigen$vec %*% (sqrt(SigmaStar.eigen$val) * rnorm(T))
            dens.old                        <- -1/2 * sum(log(SigmaStar.eigen$val[1:(T-2)])) -1/2 * t(u.old[((i-1)*T+1):(i*T)] - muStar) %*% (SigmaGenInv %*% (u.old[((i-1)*T+1):(i*T)] - 
                                                muStar))
            return(list(u.star=uStar, dens.star=dens, u.star.old=uStar.old, dens.old=dens.old)) } ) }










################################################################################
##### Functions used in Metropolis-Hastings updates                            #
################################################################################
LogLik <- function(SigmaInv.diag, gamma, R.age.spam, F.theta.Mm) {                                          # Function used to calculate log likelihoods
    return(.5*(sum(log(SigmaInv.diag)) - sum(SigmaInv.diag* (y - F.theta.Mm - R.age.spam %*% gamma)^2)))
    }
ssreLik <- function(N, phi, ssre) {                                                                         # Function used to calculate log likelihood for study-specific random effects
    return((-N*phi - sum(ssre^2)/exp(phi))/2)
    }
LogPriorPhi <- function(phi) {                                                                              # Function used to calculate log prior for study-specific random effects
    return(phi/2)
    }
##### Functions used in calculation of the log posteriors for the precision  ###
##### parameters for non-linear trends as described in Danaei et al pp.14-16 ###
CalcThetaPost <- function(i, uvw) {
    return(uvw[((i-1)*T+1):(i*T)] %*% P %*% uvw[((i-1)*T+1):(i*T)])
    }
LogPostThetaC <- function(theta_c, u) {
    return((J*(T-2)-1) * theta_c / 2 - exp(theta_c)/2 * sum(unlist(lapply(1:J, CalcThetaPost, u))))
    }
LogPostThetaR <- function(theta_r, v) {
    return((sum(multipleRegionsInSregion)*(T-2)-1) * theta_r / 2 - exp(theta_r)/2 * sum(unlist(lapply((1:K)[multipleRegionsInSregion], CalcThetaPost, v))))
    }
LogPostThetaS <- function(theta_s, sv) {
    return((L*(T-2)-1) * theta_s / 2 - exp(theta_s)/2 * sum(unlist(lapply(1:L, CalcThetaPost, sv))))
    }
LogPostThetaG <- function(theta_g, w) {
    return((T-2-1) * theta_g / 2 - exp(theta_g)/2 * w %*% P %*% w)
    }










################################################################################
##### Tuning function to help efficient MCMC updates                           #
##### See Gelman, Roberts, Gilk, Bayesian Statistics 5, pp.599-607             #
################################################################################
adaptJump <- function(n, pjump, pgoal=NULL, max.mult=5) {
    pjump[pjump==1]=0.999
    if(is.null(pgoal)) {
        const=rep(log(.44),length(n))                                                   # One dimensional jump
        const[n==2]=log(.35)                                                            # Two dimensional jump
        const[n==3]=log(.32)                                                            # Three dimensional jump
        const[n>3] =log(.25)                                                            # More than three dimensional jump (slightly conservative)
        }
    else {
        const=log(pgoal)
        }
    return(min(max.mult,max(1/max.mult,const/log(pjump))))
    }










################################################################################
##### Deviance print function                                                  #
################################################################################
printDeviance <- function() {
    mean.deviance   <- round(mean(deviance[burnt], na.rm=TRUE),2)                                           # Calculates estimated mean deviance
    p_D             <- round(var(deviance[burnt],  na.rm=TRUE)/2,2)                                         # Calculates effective number of parameters
    dic             <- round(mean(deviance[burnt], na.rm=TRUE) + var(deviance[burnt],na.rm=TRUE)/2, 2)      # Calculates DIC
    cat("mean deviance =", mean.deviance, "\n", "p_d =", p_D, "\n", "p =", p, "\n", "DIC =", dic, "\n") }   # Prints values to screen










################################################################################
##### Trace plot function                                                      #
##### This function prints traceplots for a selection of parameters to a pdf   #
##### document. The list of parameters within the function may be changed      #
##### without affecting the remainder of the code                              #
################################################################################
tracePlots <- function() {
        pdf(paste(filename, "_univariate_traceplots",".pdf",sep=''), width=10, height=7.5); par(mfrow=c(3,2), mar=c(0.5,4,0.5,0))  # Opens PDF document
        plot(phi_s,     type='l', xlab='', ylab='phi_s',    xaxt='n')                   # Log variance for normal prior for superregion random intercepts      (log kappa_a^r)
        plot(phi_r,     type='l', xlab='', ylab='phi_r',    xaxt='n')                   # Log variance for normal prior for region random intercepts           (log kappa_a^s)
        plot(phi_c,     type='l', xlab='', ylab='phi_c',    xaxt='n')                   # Log variance for normal prior for country random intercepts          (log kappa_a^c)
        plot(eta_s,     type='l', xlab='', ylab='eta_s',    xaxt='n')                   # Log variance for normal prior for superregion random slopes          (log kappa_b^r)
        plot(eta_r,     type='l', xlab='', ylab='eta_r',    xaxt='n')                   # Log variance for normal prior for region random slopes               (log kappa_b^s)
        plot(eta_c,     type='l', xlab='', ylab='eta_c',    xaxt='n')                   # Log variance for normal prior for country random slopes              (log kappa_b^c)
        plot(rho_s,     type='l', xlab='', ylab='rho_s',    xaxt='n')                   # Log variance for normal prior for superregion stratum random intercepts      (log kappa_a^r)
        plot(rho_r,     type='l', xlab='', ylab='rho_r',    xaxt='n')                   # Log variance for normal prior for region stratum random intercepts 
        plot(rho_c,     type='l', xlab='', ylab='rho_c',    xaxt='n')                   # Log variance for normal prior for country stratum random intercepts 
        plot(psi_s,     type='l', xlab='', ylab='psi_s',    xaxt='n')                   # Log variance for normal prior for superregion stratum random slopes 
        plot(psi_r,     type='l', xlab='', ylab='psi_r',    xaxt='n')                   # Log variance for normal prior for region stratum random slopes
        plot(psi_c,     type='l', xlab='', ylab='psi_c',    xaxt='n')                   # Log variance for normal prior for country stratum random slopes
        plot(phi_natl,  type='l', xlab='', ylab='phi_natl', xaxt='n')                   # Log variance of random effects for national studies (analogous to collapsed log nu_w and log nu_u)
        plot(phi_subn,  type='l', xlab='', ylab='phi_subn', xaxt='n')                   # Log variance of random effects for subnational studies               (log nu_s)
        plot(phi_comm,  type='l', xlab='', ylab='phi_comm', xaxt='n')                   # Log variance of random effects for community studies                 (log nu_c)
        plot(omicron_natl,  type='l', xlab='', ylab='omicron_natl', xaxt='n')           # Log variance of random effects for u-r diff in national studies 
        plot(omicron_subn,  type='l', xlab='', ylab='omicron_subn', xaxt='n')           # Log variance of random effects for u-r diff in subnational studies              
        plot(omicron_comm,  type='l', xlab='', ylab='omicron_comm', xaxt='n')           # Log variance of random effects for u-r diff in community studies                 
        plot(tau,       type='l', xlab='', ylab='tau',      xaxt='n')                   # Log variance for within-study errors that differ between age groups  (log tau)
        plot(theta_c,   type='l', xlab='', ylab='theta_c',  xaxt='n')                   # Log precision parameter for random walk at country level             (log lambda_c)
        plot(theta_r,   type='l', xlab='', ylab='theta_r',  xaxt='n')                   # Log precision parameter for random walk at region level              (log lambda_s)
        plot(theta_s,   type='l', xlab='', ylab='theta_s',  xaxt='n')                   # Log precision parameter for random walk at superregion level         (log lambda_r)
        plot(theta_g,   type='l', xlab='', ylab='theta_g',  xaxt='n')                   # Log precision parameter for random walk at global level              (log lambda_g)
        plot(deviance,  type='l', xlab='', ylab='deviance', xaxt='n')                   # Deviance
        plot(theta[,1], type='l', xlab='', ylab='a_g',      xaxt='n')                   # Global random intercept
        plot(theta[,2], type='l', xlab='', ylab='b_g',      xaxt='n')                   # Global random slope
        for(i in 1:p)   plot(theta[,4+4*L+4*sum(multipleRegionsInSregion)+4*J+2*N+i], type='l', xlab='', ylab=paste('covar', i),xaxt='n')   # Covariate terms  (beta matrix)
            # The theta[,4+4*L+4*sum(multipleRegionsInSregion)+4*J] terms are the linear intercepts and slopes at global, superregion, region and country level respectively
        for(i in 1:10)  plot(gamma[,i], type='l', xlab='', ylab=paste('gamma', i),xaxt='n')                                                 # Age model parameters (psi and phi terms)
        for(i in 1:5)   plot(log(sigma2[,i]), type='l', xlab='', ylab=paste('sigma2', i),xaxt='n')     # Log variances for country-specific random spline coefficients (sigma^2 terms)
    dev.off()  # Closes PDF document
    }
#### END OF FUNCTIONS ##########################################################
